/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

const vec3 c1 = vec3(0.4);
const vec3 c2 = vec3(0.7);
const vec3 c3 = vec3(0.2);
const vec3 c4 = vec3(0.1);
const vec3 c5 = vec3(0.3);
const vec3 c6 = vec3(0.1);
float rand(vec2 n) { 
	return fract(sin(dot(n, vec2(12.9898, 4.1414))) * 43758.5453);
}
float noise(vec2 n) {
	const vec2 d = vec2(0.0, 1.0);
	vec2 b = floor(n), f = smoothstep(vec2(0.0), vec2(1.0), fract(n));
	return mix(mix(rand(b), rand(b + d.yx), f.x), mix(rand(b + d.xy), rand(b + d.yy), f.x), f.y);
}
float fbm(vec2 n) {
	float total = 0.0, amplitude = 1.0;
	for (int i = 0; i < 7; i++) {
		total += noise(n) * amplitude;
		n += n;
		amplitude *= 0.5;
	}
	return total;
}
void main(void)
{
	vec2 uv = gl_FragCoord.xy / iResolution.xy; 
	vec2 p = gl_FragCoord.xy * 8.0 / iResolution.xx;
    p.x-=iGlobalTime*.3;
	float q = fbm(p - iGlobalTime * 0.1);
	vec2 r2 = vec2(fbm(p + q + iGlobalTime * 0.7 - p.x - p.y), fbm(p + q - iGlobalTime * 0.4));
	vec3 c = mix(c1, c2, fbm(p + r2)) + mix(c3, c4, r2.x) - mix(c5, c6, r2.y);
	vec4 smoke = vec4(c * cos(1.57 * gl_FragCoord.y / iResolution.y+.2),1.0);
    float m=uv.x*.5+.5;
    float r=.5+m*(fbm(5.*m*uv.xy)-.5);
    float rr=.5+m*(fbm(.1*m*uv.xy-iGlobalTime*.2)-.5);
    float h=.5+m*(fbm(5.*m+.001*vec2(uv.x,.5)+iGlobalTime*.3)-.9);
    h*=.8;
    vec4 sky=mix(vec4(0.,.5,.7,1.),vec4(.8,.7,.8,1.),rr);
    vec4 ground=mix(vec4(.2,.9,0.,1.),vec4(.4,.2,0.,1.),r);
    ground-=.05;
    gl_FragColor=vec4(mix(ground,sky,smoothstep(h,h+.01,uv.y))+smoke);
}